/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.heat;

import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.config.OreTooltipMode;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public enum Heat {
    WARMING(1.0f, 80.0f, TextFormatting.GRAY, TextFormatting.DARK_GRAY),
    HOT(80.0f, 210.0f, TextFormatting.GRAY, TextFormatting.DARK_GRAY),
    VERY_HOT(210.0f, 480.0f, TextFormatting.GRAY, TextFormatting.DARK_GRAY),
    FAINT_RED(480.0f, 580.0f, TextFormatting.DARK_RED),
    DARK_RED(580.0f, 730.0f, TextFormatting.DARK_RED),
    BRIGHT_RED(730.0f, 930.0f, TextFormatting.RED),
    ORANGE(930.0f, 1100.0f, TextFormatting.GOLD),
    YELLOW(1100.0f, 1300.0f, TextFormatting.YELLOW),
    YELLOW_WHITE(1300.0f, 1400.0f, TextFormatting.YELLOW),
    WHITE(1400.0f, 1500.0f, TextFormatting.WHITE),
    BRILLIANT_WHITE(1500.0f, 1601.0f, TextFormatting.WHITE);

    private static final Heat[] VALUES;
    final TextFormatting format;
    final TextFormatting alternate;
    private final float min;
    private final float max;

    public static float maxVisibleTemperature() {
        return BRILLIANT_WHITE.getMax();
    }

    @Nullable
    public static Heat getHeat(float temperature) {
        for (Heat heat : VALUES) {
            if (!(heat.min <= temperature) || !(temperature < heat.max)) continue;
            return heat;
        }
        if (temperature > Heat.BRILLIANT_WHITE.max) {
            return BRILLIANT_WHITE;
        }
        return null;
    }

    @Nullable
    public static String getTooltipColorless(float temperature) {
        Heat heat = Heat.getHeat(temperature);
        if (heat != null) {
            StringBuilder b = new StringBuilder();
            b.append(I18n.func_135052_a((String)Helpers.getEnumName(heat), (Object[])new Object[0]));
            if (heat != BRILLIANT_WHITE) {
                for (int i = 1; i <= 4; ++i) {
                    if (temperature <= heat.getMin() + (float)i * 0.2f * (heat.getMax() - heat.getMin())) continue;
                    b.append("\u2605");
                }
            }
            return b.toString();
        }
        return null;
    }

    @Nullable
    public static String getTooltip(float temperature) {
        Heat heat = Heat.getHeat(temperature);
        String tooltip = Heat.getTooltipColorless(temperature);
        if (tooltip != null && heat != null) {
            tooltip = heat.format + tooltip;
            if (ConfigTFC.Client.TOOLTIP.oreTooltipMode == OreTooltipMode.ADVANCED) {
                tooltip = tooltip + " : " + I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{Math.round(temperature)});
            }
        }
        return tooltip;
    }

    @Nullable
    public static String getTooltipAlternate(float temperature) {
        Heat heat = Heat.getHeat(temperature);
        String tooltip = Heat.getTooltipColorless(temperature);
        if (tooltip != null && heat != null) {
            tooltip = heat.alternate + tooltip;
            if (ConfigTFC.Client.TOOLTIP.oreTooltipMode == OreTooltipMode.ADVANCED) {
                tooltip = tooltip + " : " + I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{Math.round(temperature)});
            }
        }
        return tooltip;
    }

    private Heat(float min, float max, TextFormatting format, TextFormatting alternate) {
        this.min = min;
        this.max = max;
        this.format = format;
        this.alternate = alternate;
    }

    private Heat(float min, float max, TextFormatting format) {
        this(min, max, format, format);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    static {
        VALUES = Heat.values();
    }
}

